﻿using System;
using System.Collections.Generic;
using System.Linq;

namespace Zipping
{
    class Program
    {
        static void Main(string[] args)
        {
            // Listing 8-24. Spinanie dwóch sekwencji w jedną.
            IEnumerable<TimeSpan> lapTimes = GetLapTimes();
            IEnumerable<double> fuelLevels = GetLapFuelLevels();
            var lapInfo = lapTimes.Zip(fuelLevels, (time, fuel) =>
                new
                {
                    LapTime = time,
                    FuelLevel = fuel
                });

            foreach (var lap in lapInfo)
            {
                Console.WriteLine(lap);
            }
        }

        private static IEnumerable<double> GetLapFuelLevels()
        {
            return from i in Enumerable.Range(1, 10)
                   select 85 - i * 8.2;
        }

        private static IEnumerable<TimeSpan> GetLapTimes()
        {
            return from i in Enumerable.Range(1, 10)
                   select TimeSpan.FromSeconds(150 - i * 0.21);
        }
    }
}
